local M = {}

local function init()
   electrics.values.crownvicdrls = 0
end

local function reset()
   init()
end

local function updateGFX(dt)
   if electrics.values.ignitionLevel == 2 then
      if electrics.values['gear'] == "P" or electrics.values.lowbeam == 1 or electrics.values.highbeam == 1 then
         electrics.values.crownvicdrls = 0 -- turn off DRLs in park mode
      else
         electrics.values.crownvicdrls = 1 -- turn on DRLs in other modes
      end
   else
      electrics.values.crownvicdrls = 0 -- turn off DRLs when ignition is off
   end
end

M.onInit = init
M.onReset = init
M.updateGFX = updateGFX

return M